/*******************************************************
Filename		:  FA_REGULAR_RESULT_PDL_data1.sql
Release 		:  c2.0
SIR			:  1529
Description		:  Migrate portable data logger data from the TSRRSULT, TSRDLIN and TSRFACT tables to
			   the FA_REGULAR_RESULT fact table.
Author			:  Christine Tsang
Date			:  7/23/2003
			   7/31/2003 -- updated date logic; added PK constraint -JW
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
			   07/23/2004 --added organization_is_number -JW
			   08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
Comments		:  Run after fa_regular_result_data1.sql.
**********************************************************/
spool FA_REGULAR_RESULT_PDL_data1.log

set serveroutput on
DECLARE

cursor orgs is
	select organization_id, organization_is_number
	from di_org
	order by organization_id;

BEGIN

FOR v_org in orgs loop

INSERT INTO FA_REGULAR_RESULT (pk_isn,
	RESULT_VALUE,
	RESULT_VALUE_TEXT,
	SAMPLE_FRACTION_TYPE,
	RESULT_VALUE_TYPE,
	STATISTIC_TYPE,
	RESULT_VALUE_STATUS,
	WEIGHT_BASIS_TYPE,
	TEMPERATURE_BASIS_LEVEL,
	DURATION_BASIS,
	LAB_CERTIFIED,
	LAB_BATCH_ID,
	ANALYSIS_DATE_TIME,
	--ANALYSIS_TIME,
	ANALYSIS_TIME_ZONE,
	DISTANCE_MEASURE_FROM,
	DISTANCE_MEASURE_TO,
	REPLICATE_ANALYSIS_COUNT,
	PRECISION,
	CONFIDENCE_LEVEL,
	DILUTION_INDICATOR,
	RECOVERY_INDICATOR,
	CORRECTION_INDICATOR,
	RESULT_IS_NUMBER,
	ORGANIZATION_ID,
	ORGANIZATION_IS_NUMBER,
	ACTIVITY_MEDIUM,
	ACTIVITY_IS_NUMBER,
	FK_CHAR,
	TSRCHAR_ORG_ID,
	FK_UNIT_CONVERSION,
	TSRUOM_ORG_ID,
	TSRANLPR_IS_NUMBER,
	TSRANLPR_ORG_ID,
	TSRLSPP_IS_NUMBER,
	TSRLSPP_ORG_ID,
	TSRLAB_IS_NUMBER,
	BIAS,
	CONF_LVL_CORR_BIAS,
      PORTABLE_DATA_LOGGER, 
	TSMPRMVL_IS_NUMBER, 
--activity elements
	ACTIVITY_START_DATE_TIME,
	--ACTIVITY_START_TIME,
	ACT_START_TIME_ZONE,
	TSRSTVST_IS_NUMBER,
 	ACTIVITY_ID,            
 	REPLICATE_NUMBER,       
 	ACTIVITY_TYPE,          
 	ACTIVITY_CATEGORY,      
 	ACTIVITY_INTENT,        
 	--ACTIVITY_COMMUNITY, 7/21/2003
	ACTIVITY_STOP_DATE_TIME,     
	--ACTIVITY_STOP_TIME,     
	ACT_STOP_TIME_ZONE,     
	ACTIVITY_REL_DEPTH,     
	ACTIVITY_DEPTH,         
	ACTIVITY_DEPTH_UNIT,    
	ACTIVITY_UPPER_DEPTH,   
	ACTIVITY_LOWER_DEPTH,  
	UPR_LWR_DEPTH_UNIT,
	tsrfldpr_is_number,
	tsrgrcfg_is_number,
	TSRFLDGR_IS_NUMBER,
	TSRMATRX_IS_NUMBER
)
SELECT
      seq_FA_REGULAR_RESULT.nextval,
	RSULT.VALUE_MEASURE,		
	RSULT.VALUE_TEXT,		
	RSULT.SMPL_FRAC_TYPE_NM,	
	RSULT.VALUE_TYPE_NAME,		
	RSULT.STATISTIC_TYPE_NM,	
	RSULT.VALUE_STATUS,		
	RSULT.WT_BASIS_TYPE_NM,		
	RSULT.TEMP_BASIS_LVL_NM,	
	RSULT.DUR_BASIS_TYPE_NM,	
	RSULT.LAB_CERT_IND_CODE,	
	RSULT.LAB_BATCH_ID_CODE,
	DECODE (to_char(rsult.analysis_date,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		TO_DATE(to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS') ),

	--TO_DATE(to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS'), 	
	--RSULT.ANALYSIS_DATE,		
	--RSULT.ANALYSIS_TIME,		
	RSULT.ANALYSIS_TIME_ZONE,	
	RSULT.REF_PT_FROM_NAME,	
	RSULT.REF_PT_TO_NAME,		
	RSULT.REPL_ANALYSIS_NUM,	
	RSULT.PRECISION_AMT_TEXT,	
	RSULT.CONF_LVL_PCT_MSR	,	
	RSULT.DILUTION_IND_CODE,	
	RSULT.RECOVERY_IND_CODE,	
	RSULT.CORRECTION_IND_CD,	
	RSULT.TSRRSULT_IS_NUMBER,    	
	RSULT.TSRRSULT_ORG_ID,
	V_ORG.ORGANIZATION_IS_NUMBER,
	FDACT.MEDIUM_TYPE_NAME,	
	FDACT.TSRFDACT_IS_NUMBER,
	RSULT.TSRCHAR_IS_NUMBER,
	RSULT.TSRCHAR_ORG_ID,
	RSULT.TSRUOM_IS_NUMBER,
	RSULT.TSRUOM_ORG_ID,
	RSULT.TSRANLPR_IS_NUMBER,
	RSULT.TSRANLPR_ORG_ID,
	RSULT.TSRLSPP_IS_NUMBER,
	RSULT.TSRLSPP_ORG_ID,
	RSULT.TSRLAB_IS_NUMBER,
	RSULT.BIAS,
	RSULT.CONF_LVL_CORR_BIAS,
      dlin.line_number||' '||dlin.line_name,
	RSULT.TSMPRMVL_IS_NUMBER,
--activity elements
	DECODE (to_char(FDACT.START_DATE,'DD-MON-YYYY'), 	NULL, NULL,
								'01-JAN-0001', NULL,
		TO_DATE(to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_DATE,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS') ),
	--TO_DATE(to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS'), 
	--FDACT.START_DATE,		
	--FDACT.START_TIME,		
	FDACT.START_TIME_ZONE,		
	FDACT.TSRSTVST_IS_NUMBER,
 	FDACT.ID_CODE,            
 	FDACT.REPLICATE_NUMBER,       
 	FDACT.TYPE_NAME,          
 	FDACT.CATEGORY_TYPE_NAME,      
 	FDACT.INTENT_TYPE_NAME,        
 	--FDACT.COMMUNITY_NAME,     7/21/2003	
	DECODE (to_char(FDACT.STOP_DATE,'DD-MON-YYYY'), 	NULL, NULL,
								'01-JAN-0001', NULL,
		TO_DATE(to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_DATE,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS') ),
	--TO_DATE(to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS'), 
	--FDACT.STOP_DATE,     
	--FDACT.STOP_TIME,     
	FDACT.STOP_TIME_ZONE,     
	FDACT.RELTV_DEPTH_NAME,     
	FDACT.DEPTH_TO_ACTIVITY,         
	FDACT.DEPTH_TO_ACT_UN_CD,    
	FDACT.UPPER_DEPTH_TO_ACT,   
	FDACT.LOWER_DEPTH_TO_ACT,  
	FDACT.DEPTH_MSR_UNT_CD,
	FDACT.tsrfldpr_is_number,
	FDACT.tsrgrcfg_is_number,
	FDACT.TSRFLDGR_IS_NUMBER,
	FDACT.TSRMATRX_IS_NUMBER
FROM STORET1.TSRRSULT RSULT, 
     Storet1.TSRFDACT FDACT,
     STORET1.TSRDLIN DLIN
WHERE rsult.tsrdlin_is_number = dlin.tsrdlin_is_number
      and rsult.tsrdlin_org_id = dlin.tsrdlin_org_id
      and dlin.tsrfdact_is_number = fdact.tsrfdact_is_number
      and dlin.tsrfdact_org_id = fdact.tsrfdact_org_id
      AND RSULT.value_status ='F'
	AND fdact.medium_type_name in ('Air','Sediment','Soil','Water','Other')
	AND fdact.category_type_name = 'Portable Data Logger'
	AND FDACT.TSRFDACT_ORG_ID = v_org.organization_id;
commit;
end loop;
commit;
end;
/
commit;

alter table FA_REGULAR_RESULT
add constraint pk_regular_result primary key (pk_isn)
using index
tablespace storetindx
storage(initial 15m next 10m);
--storage(initial 10m next 5m);

spool off;